#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <wchar.h>

static char* getShortMonthString(WORD month);
static char* getShortGermanMonthString(WORD month);
static char* getLongMonthString(WORD month);
static char* getLongGermanMonthString(WORD month);

/* run this program using the console pauser or add your own getch, system("pause") or input loop */

int main(int argc, char *argv[]) 
{
    SYSTEMTIME lt;
    char* shortMonthString;
    int i;
    
    GetLocalTime(&lt);	
	
    if(argc > 1)
    {
        if(!strcmp(argv[1], "MM/DD/YYYY"))
        {
            printf("%02i/%02i/%04i", lt.wMonth, lt.wDay, lt.wYear);
        }
        else if(!strcmp(argv[1], "M/D/YYYY"))
        {
            printf("%i/%i/%04i", lt.wMonth, lt.wDay, lt.wYear);
        }
        else if(!strcmp(argv[1], "D/M/YYYY"))
        {
            printf("%i/%i/%04i", lt.wDay, lt.wMonth, lt.wYear);
        }
        else if(argc > 1 && !strcmp(argv[1], "DD/MM/YYYY"))
        {
            printf("%02i/%02i/%04i", lt.wDay, lt.wMonth, lt.wYear);
        }
        else if(!strcmp(argv[1], "DD.MM.YYYY"))
        {
            printf("%02i.%02i.%04i", lt.wDay, lt.wMonth, lt.wYear);
        }
		else if(!strcmp(argv[1], "D.M.YYYY"))
        {
            printf("%i.%i.%04i", lt.wDay, lt.wMonth, lt.wYear);
        }
        else if(argc > 1 && !strcmp(argv[1], "YYYY-MM-DD"))
        {
            printf("%04i-%02i-%02i", lt.wYear, lt.wDay, lt.wMonth);
        }
        else if(!strcmp(argv[1], "YYYY/MM/DD"))
        {
            printf("%04i/%02i/%02i", lt.wYear, lt.wDay, lt.wMonth);
        }
		else if(!strcmp(argv[1], "YYYY/M/D"))
        {
            printf("%04i/%i/%i", lt.wYear, lt.wDay, lt.wMonth);
        }
		else if((argc > 2) && !strcmp(argv[1], "DD-MMM-YYYY") && !strcmp(argv[2], "DE"))
        {
            printf("%02i-%s-%04i", lt.wDay, getShortGermanMonthString(lt.wMonth), lt.wYear);
        }
        else if(!strcmp(argv[1], "DD-MMM-YYYY"))
        {
            printf("%02i-%s-%04i", lt.wDay, getShortMonthString(lt.wMonth), lt.wYear);
        }
		else if((argc > 2) && !strcmp(argv[1], "D-MMM-YYYY") && !strcmp(argv[2], "DE"))
        {
            printf("%i-%s-%04i", lt.wDay, getShortGermanMonthString(lt.wMonth), lt.wYear);
        }
        else if(!strcmp(argv[1], "D-MMM-YYYY"))
        {
            printf("%i-%s-%04i", lt.wDay, getShortMonthString(lt.wMonth), lt.wYear);
        }
        else if((argc > 2) && !strcmp(argv[1], "D. MMM. YYYY") && !strcmp(argv[2], "DE"))
        {
            printf("%i. %s. %04i", lt.wDay, getShortGermanMonthString(lt.wMonth), lt.wYear);
        }
		else if(!strcmp(argv[1], "D. MMM. YYYY"))
        {
            printf("%i. %s. %04i", lt.wDay, getShortMonthString(lt.wMonth), lt.wYear);
        }
		else if(!strcmp(argv[1], "MMMM D, YYYY"))
	    {
			printf("%s %i, %04i", lt.wDay, getLongMonthString(lt.wMonth), lt.wDay, lt.wYear);
		}
        else if(!strcmp(argv[1], "MMMM D YYYY"))
	    {
			printf("%s %ith %04i", getLongMonthString(lt.wMonth), lt.wDay, lt.wYear);
		}
		else if((argc > 2) && !strcmp(argv[1], "D. MMMM YYYY") && !strcmp(argv[2], "DE"))
	    {
			printf("%i. %s %04i", lt.wDay, getLongGermanMonthString(lt.wMonth), lt.wYear);
		}
		else if(!strcmp(argv[1], "D. MMMM YYYY"))
	    {
			printf("%i. %s %04i", lt.wDay, getLongMonthString(lt.wMonth), lt.wYear);
		}
        else
        {
            printf("%02i-%s-%04i", lt.wDay, getShortMonthString(lt.wMonth), lt.wYear);
        }		
    }
    else
    {
        printf("%02i-%s-%04i", lt.wDay, getShortMonthString(lt.wMonth), lt.wYear);
    }
    
    return 0;
}

static char* getShortMonthString(WORD month)
{
    char* shortMonthString;
    
    switch(month)
    {
        case 1:
            shortMonthString = "Jan";
            break;
        case 2:
            shortMonthString = "Feb";
            break;
        case 3:
            shortMonthString = "Mar";
            break;
        case 4:
            shortMonthString = "Apr";
            break;
        case 5:
            shortMonthString = "May";
            break;
        case 6:
            shortMonthString = "Jun";
            break;
        case 7:
            shortMonthString = "Jul";
            break;
        case 8:
            shortMonthString = "Aug";
            break;
        case 9:
            shortMonthString = "Sep";
            break;
        case 10:
            shortMonthString = "Oct";
            break;
        case 11:
            shortMonthString = "Nov";
            break;
        case 12:
            shortMonthString = "Dec";
            break;
        default:
            return NULL;
    }
    
    return shortMonthString;
}

static char* getShortGermanMonthString(WORD month)
{
    char* shortGermanMonthString;
    
    switch(month)
    {
        case 1:
            shortGermanMonthString = "Jan";
            break;
        case 2:
            shortGermanMonthString = "Feb";
            break;
        case 3:
            shortGermanMonthString = "Mär";
            break;
        case 4:
            shortGermanMonthString = "Apr";
            break;
        case 5:
            shortGermanMonthString = "Mai";
            break;
        case 6:
            shortGermanMonthString = "Jun";
            break;
        case 7:
            shortGermanMonthString = "Jul";
            break;
        case 8:
            shortGermanMonthString = "Aug";
            break;
        case 9:
            shortGermanMonthString = "Sep";
            break;
        case 10:
            shortGermanMonthString = "Oct";
            break;
        case 11:
            shortGermanMonthString = "Nov";
            break;
        case 12:
            shortGermanMonthString = "Dez";
            break;
        default:
            return NULL;
    }
    
    return shortGermanMonthString;
}

static char* getLongMonthString(WORD month)
{
    char* longMonthString;
    
    switch(month)
    {
        case 1:
            longMonthString = "January";
            break;
        case 2:
            longMonthString = "February";
            break;
        case 3:
            longMonthString = "March";
            break;
        case 4:
            longMonthString = "April";
            break;
        case 5:
            longMonthString = "May";
            break;
        case 6:
            longMonthString = "June";
            break;
        case 7:
            longMonthString = "July";
            break;
        case 8:
            longMonthString = "August";
            break;
        case 9:
            longMonthString = "September";
            break;
        case 10:
            longMonthString = "October";
            break;
        case 11:
            longMonthString = "November";
            break;
        case 12:
            longMonthString = "December";
            break;
        default:
            return NULL;
    }
    
    return longMonthString;
}

static char* getLongGermanMonthString(WORD month)
{
    char* longGermanMonthString;
    
    switch(month)
    {
        case 1:
            longGermanMonthString = "Januar";
            break;
        case 2:
            longGermanMonthString = "Februar";
            break;
        case 3:
            longGermanMonthString = "März";
            break;
        case 4:
            longGermanMonthString = "April";
            break;
        case 5:
            longGermanMonthString = "Mai";
            break;
        case 6:
            longGermanMonthString = "Juni";
            break;
        case 7:
            longGermanMonthString = "Juli";
            break;
        case 8:
            longGermanMonthString = "August";
            break;
        case 9:
            longGermanMonthString = "September";
            break;
        case 10:
            longGermanMonthString = "October";
            break;
        case 11:
            longGermanMonthString = "November";
            break;
        case 12:
            longGermanMonthString = "Dezember";
            break;
        default:
            return NULL;
    }
    
    return longGermanMonthString;
}

